<x-app-layout>
    <x-slot name="header">
        Country
    </x-slot>

    <!-- Row -->
    <div class="row">
        <div class="col-md-10">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">
                        @isset($country->id)
                        Edit Country
                        @else
                        Add New Country
                        @endisset
                    </div>
                </div>
                <form action="
                    @isset($country->id)
                        {{ route('admin.location.country.update', $country->id) }}
                    @else
                        {{ route('admin.location.country.store') }}
                    @endisset
                    " method="post" enctype="multipart/form-data">
                    <div class="card-body">
                        @isset($country->id)
                        @method('PUT')
                        @endisset
                        @csrf
                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="name">Country Name :</label>
                            <div class="">
                                <input type="search" class="form-control @error('name') is-invalid @enderror"
                                    name="name" value="{{ old('name', $country->name) }}" placeholder="Country Name">
                            </div>
                            @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="code">Country Code :</label>
                            <div class="">
                                <input type="search" class="form-control @error('code') is-invalid @enderror"
                                    name="code" value="{{ old('code', $country->code) }}" placeholder="Country code">
                            </div>
                            @error('code')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="phone_code">Country Phone Code :</label>
                            <div class="">
                                <input type="search" class="form-control @error('phone_code') is-invalid @enderror"
                                    name="phone_code" value="{{ old('phone_code', $country->phone_code) }}"
                                    placeholder="Country Phone Code">
                            </div>
                            @error('phone_code')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="currency">Country Currency :</label>
                            <div class="">
                                <input type="search" class="form-control @error('currency') is-invalid @enderror"
                                    name="currency" value="{{ old('currency', $country->currency) }}"
                                    placeholder="Country currency">
                            </div>
                            @error('currency')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="currency_symbol">Country Currency Symbol :</label>
                            <div class="">
                                <input type="search" class="form-control @error('currency_symbol') is-invalid @enderror"
                                    name="currency_symbol"
                                    value="{{ old('currency_symbol', $country->currency_symbol) }}"
                                    placeholder="Country Currency Symbol">
                            </div>
                            @error('currency_symbol')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="flag">Flag :</label>
                            <div class="">
                                <input type="file" class="form-control @error('flag') is-invalid @enderror" name="flag"
                                    value="{{ old('flag', $country->flag) }}" placeholder="Country flag"
                                    accept=".jpg, .png, image/jpeg, image/png">
                            </div>
                            @error('flag')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <label class="custom-switch form-switch me-5">
                            <input type="checkbox" name="status" value="1" class="custom-switch-input" {{ old('status',
                                $country->status) == 1 ? 'checked' : '' }}>
                            <span class="custom-switch-indicator custom-switch-indicator-lg"></span>
                            <span class="custom-switch-description">Status</span>
                        </label>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">Save</button>
                        <a href="{{route('admin.location.country.index')}}"
                            class="btn btn-default float-end">Discard</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- End Row -->
</x-app-layout>
